;----------------------------------------------------------------------------
;
;    MODULE NAME:   TWEEK.MM
;
;        $Author:   USER "Dennis"  $
;      $Revision:   1.10  $
;          $Date:   21 Dec 2006 17:54:02  $
;       $Logfile:   C:/DBAREIS/Projects.PVCS/Win32/MakeMsi/Tweek.mm.pvcs  $
;      COPYRIGHT:   (C)opyright Dennis Bareis, Australia, 2003
;                   All rights reserved.
;
;    DESCRIPTION
;    ~~~~~~~~~~~
;    This sample demonstrates how to make small changes to existing MSI
;    files although it also demonstrates a number of other PPWIZARD and
;    MAKEMSI things.
;
;    The "main" code (and all that is required) is the following:
;
;         #include "OpenMsi.MMH"
;         <$Msi "out\Tweek.mm\Msi\After.msi" template="out\Tweek.mm\Msi\Before.msi">
;             <$Property "ABCDEFG" VALUE="C:\">
;             <$Table "RadioButton">
;                 <$RowsDelete WHERE="Property = 'IAgree' AND `Order` = '2'">
;             <$/Table>
;         <$/Msi>
;----------------------------------------------------------------------------



;--- Include the correct support (MAKEMSI.MMH/DEPT.MMH for MSI Creation) ----
#define  COMPILE_CAB_FILE_NAME           TW*        ;;Good idea to alter if you wish to possibly add files to an original MAKEMSI generated MSI (if its your own - why)
#define  DBG_ALL                         Y          ;;Good unless you think it impacts performance
#include "OpenMsi.MMH"


;--- Define where files are -------------------------------------------------
#define MsiBEFORE_SRC ..\Create MSI Installers\out\TryMe.MM\MSI\TryMe.MSI
#define MsiDestDir    out\Tweek.mm\Msi
#define MsiBEFORE     <$MsiDestDir>\Before.msi
#define MsiAFTER      <$MsiDestDir>\After.msi
#define MstFile       <$MsiDestDir>\ConvertBefore2After.mst
#define TxtDifference <$MsiDestDir>\Changes.txt


;--- Prepare for my sample below --------------------------------------------
#DefineRexx ''
   ;--- Make sure the "source File" exists ---
   if FileQueryExists('<$MsiBEFORE_SRC>') = '' then
      error('The file "<$MsiBEFORE_SRC>" does not exist!',,'You should first create it by building "TRYME.MM"!');

   ;--- Clean up and prepare a "before" MSI ---------------------------------
   call FileDelete '<$MsiBEFORE>', 'N';
   call FileDelete '<$MsiAFTER>',  'N';
   call MakeDirectoryTree '<$MsiDestDir>';
   call FileCopy   '<$MsiBEFORE_SRC>', '<$MsiBEFORE>';
#DefineRexx


;--- The actual sample! -----------------------------------------------------
<$Msi "<$MsiAFTER>" template="<$MsiBEFORE>">
   ;--- Add a property ------------------------------------------------------
   <$Property "ABCDEFG" VALUE="C:\">

   ;--- Modify text of one row of the "RadioButton" table -------------------
   <$Table "RadioButton">
   #(
        <$Row @where="Property = 'IAgree' AND `Order` = 2"
              @SelfRef=^{*}^
              *Text=^replace(<$ColStr.RadioButton.Text>, "Licence", "LICENSE")^
        >
   #)
   <$/Table>

   ;--- This part turned off by default -------------------------------------
   #ifdef ADD_FILES
       ;--- Use orca to work out existing Feature (or create new) -----------
       <$Feature "ALL.3.076.0000.TryMe_simple_MAKEMSI_te">                                   ;;MAKEMSI by default creates cryptic feature root feature names (good in logs but...), you could rename...
            ;--- Create a new component -------------------------------------
            <$Component "ExtraFilesAddedDuringUpdateOfExistingMSI" Directory_="INSTALLDIR">  ;;Obviously I know "INSTALLDIR" already exists also...
                ;--- Add two files ------------------------------------------
                <$Files "Tweek.mm" KeyFile="*">
                <$Files "ReadMe.txt">
            <$/Component>
       <$/Feature>
   #endif

   ;--- Create a transform (can be applied to the "before" msi) -------------
   <$Transform "<$MstFile>">
<$/Msi>



;--- Display the changes we made above ("schedule" it after validation) -----
#(
   #define+ ONEXIT_AFTER_MSI_BUILT_AND_VALIDATED
   #DefineRexx ''
       ;--- Is MSIDIFF.VBS installed? ---------------------------------------
       call Info "MSI UPDATE COMPLETE (will now now compare if possible)";
       if   GetEnv("MSIDIFF_DIR") = '' then;
            call Info "*** MSIDIFF is not installed (so I can't compare the two databases)...";
       else;
       do;
           ;--- Make the difference file (assume in current dir or PATH) ------------
           call Info "Executing MSIDIFF.VBS to dump the changes to the MSI...";
           call Say  "";
           DiffRc = AddressCmd('cscript.exe //nologo "' || GetEnv("MSIDIFF_DIR", "Y") || 'msidiff.vbs" "<$MsiBEFORE>" "<$MsiAFTER>" >"<$TxtDifference>"');
           TypeRc = AddressCmd('type "<$TxtDifference>"');
       end;
   #DefineRexx
#)

